/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.BountifulFares;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class HangingFruitBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_222999_;

    public HangingFruitBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!HangingFruitBlock.isFullyGrown(state) && (double)random.m_188501_() < 0.2) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)AGE), 2);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i != 4 && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (i == 4) {
            HangingFruitBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42410_, 1));
            world.m_5594_(null, pos, BFSounds.HANGING_FRUIT_PICK, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
            if (!world.m_5776_()) {
                if (BountifulFares.CONFIG.isFruitReplaceWhenPicked()) {
                    BlockState blockState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
                    world.m_7731_(pos, blockState, 2);
                    world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
                } else {
                    world.m_7471_(pos, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return !HangingFruitBlock.isFullyGrown(state);
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (!HangingFruitBlock.isFullyGrown(state)) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)AGE), 2);
        }
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 4;
    }

    private static boolean isFullyGrown(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) == 4;
    }

    public void m_5581_(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (HangingFruitBlock.isFullyGrown(state)) {
            world.m_46961_(hit.m_82425_(), true);
        }
        super.m_5581_(world, state, hit, projectile);
    }
}

